/* npm t exercises/bigints/gcd-bigint_test.mjs
Difficulty: ●○○

Instructions:
- Implement the imported functionality.
- Use gcdNumber() as a starting point.
*/
suite('gcd-bigint_test.mjs');

import assert from 'node:assert/strict';
import { gcdBigint } from './gcd-bigint.mjs';

test('gcdBigint()', () => {
  assert.equal(
    gcdBigint(60n, 84n), 12n
  );

  assert.equal(
    gcdBigint(9n, 3n), 3n
  );
  assert.equal(
    gcdBigint(2n**8n, 2n**11n), 2n**8n
  );

  assert.equal(
    gcdBigint(5n, 7n), 1n
  );

  assert.equal(
    gcdBigint(0n, 3n), 3n
  );
  assert.equal(
    gcdBigint(3n, 0n), 3n
  );

  assert.equal(
    gcdBigint(11n, 11n), 11n
  );
});

test('gcdNumber()', () => {
  assert.equal(
    gcdNumber(60, 84), 12
  );

  assert.equal(
    gcdNumber(9, 3), 3
  );
  assert.equal(
    gcdNumber(2**8, 2**11), 2**8
  );

  assert.equal(
    gcdNumber(5, 7), 1
  );

  assert.equal(
    gcdNumber(0, 3), 3
  );
  assert.equal(
    gcdNumber(3, 0), 3
  );

  assert.equal(
    gcdNumber(11, 11), 11
  );
});

/**
 * Computes the greatest common divider of two integers `a` and `b`.
 * @see https://en.wikipedia.org/wiki/Euclidean_algorithm
 */
function gcdNumber(a, b) {
  while (b !== 0) {
    [a, b] = [b, a % b];
  }
  return a;
}
