/* npm t exercises/objects/stack-via-object_test.mjs
Difficulty: ●○○

Instructions:
- Implement the imported functionality.
- Use the pattern shown in createStackDemo() at the end of this file.
*/
suite('stack-via-object_test.mjs');

import assert from 'node:assert/strict';
import { createStack } from './stack-via-object.mjs';

test('Creating and using a stack', () => {
  const stack = createStack();
  assert.equal(
    stack.size, 0
  );

  stack.push('a');
  stack.push('b');
  assert.equal(
    stack.size, 2
  );

  assert.equal(
    stack.pop(), 'b'
  );
  assert.equal(
    stack.pop(), 'a'
  );
  assert.equal(
    stack.size, 0
  );

  // We can only read .size, not change it
  assert.throws(
    () => stack.size = 55,
    TypeError
  );
});

function createStackDemo() {
  const stack = [];
  return {
    // ···
  };
}
